<?php
// Include config file
require_once 'config.php';
 
// Define variables and initialize with empty values
$username = $password = "";
$username_err = $password_err = "";
 
// Processing form data when form is submitted
if($_SERVER["REQUEST_METHOD"] == "POST"){
 
    // Check if username is empty
    if(empty(trim($_POST["username"]))){
        $username_err = 'Please enter username.';
    } else{
        $username = trim($_POST["username"]);
    }
    
    // Check if password is empty
    if(empty(trim($_POST['password']))){
        $password_err = 'Please enter your password.';
    } else{
        $password = trim($_POST['password']);
    }
    
    // Validate credentials
    if(empty($username_err) && empty($password_err)){
        // Prepare a select statement
        $sql = "SELECT username, password FROM user_bc WHERE username = ?";
        
        if($stmt = mysqli_prepare($link, $sql)){
            // Bind variables to the prepared statement as parameters
            mysqli_stmt_bind_param($stmt, "s", $param_username);
            
            // Set parameters
            $param_username = $username;
            
            // Attempt to execute the prepared statement
            if(mysqli_stmt_execute($stmt)){
                // Store result
                mysqli_stmt_store_result($stmt);
                
                // Check if username exists, if yes then verify password
                if(mysqli_stmt_num_rows($stmt) == 1){                    
                    // Bind result variables
                    mysqli_stmt_bind_result($stmt, $username, $hashed_password);
                    if(mysqli_stmt_fetch($stmt)){
                        if(password_verify($password, $hashed_password)){
                            /* Password is correct, so start a new session and
                            save the username to the session */
                            session_start();
                            $_SESSION['username'] = $username;      
                            header("location: dashboard.php");
                        } else{
                            // Display an error message if password is not valid
                            $password_err = 'The password you entered was not valid.';
                        }
                    }
                } else{
                    // Display an error message if username doesn't exist
                    $username_err = 'No account found with that username.';
                }
            } else{
                echo "Oops! Something went wrong. Please try again later.";
            }
        }
        
        // Close statement
        mysqli_stmt_close($stmt);
    }
    
    // Close connection
    mysqli_close($link);
}
?>
 
<!DOCTYPE html>
<html lang="en">


<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="https://www.w3schools.com/w3css/4/w3.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">




<head>
  <title>TOYAM SECURITY AND FACILITY MANAGEMENT PVT. LTD.</title>
  
  
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="http://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.0/jquery.min.js"></script>
    <script src="http://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js"></script>
    <script>
      $(function () {
        $('#veer_button').click(function () {
          var fname2 = $('#fname').val();
          var lname2 = $('#lname').val();
          var email2 = $('#email').val();
          var phone2 = $('#phone').val();
          var message2 = $('#message').val();
          console.log('starting ajax');
          $.ajax({
            url: "./insert.php",
            type: "post",
            data: { fname: fname2, lname: lname2, email: email2, phone: phone2, message: message2 },
            success: function (data) {
              var dataParsed = JSON.parse(data);
              console.log(dataParsed);
            }
          });

        });
      });

	  
	  
function myFunction() {
    alert("Your Contact saved successfully! We will get back to you soon.Thankyou!!!");
}
    </script>

    <style>
      .custom{
         margin-left:200px;
      }
    </style>
  
  
  <style>

    
   .login {
  border-radius:5px;
  background-color:#219cd1;
  margin:0 auto;
  max-width:100%;
 
}
.login-header {
  color:#fff;
  text-align:center;
  font-size:120%;
}
/* .login-header h1 {
   text-shadow: 0px 5px 15px #000; */
}
.login-form {
  border:.5px solid #fff;
  background:#4facff;
  border-radius:10px;
  box-shadow:0px 0px 10px #000;
}
.login-form h3 {
  text-align:left;
  margin-left:40px;
  color:#fff;
}
.login-form {
  box-sizing:border-box;
  padding-top:15px;
	padding-bottom:10%;
  margin:5% auto;
  text-align:center;
}
.login input[type="text"],
.login input[type="password"] {
  max-width:250px;
	width: 60%;
  line-height:2em;
  font-family: 'Ubuntu', sans-serif;
  margin:1em 2em;
  border-radius:5px;
  border:2px solid #f2f2f2;
  outline:none;
  padding-left:0px;
}
.login-form input[type="button"] {
  height:30px;
  width:65px;
  background:#fff;
  border:2px solid #f2f2f2;
  border-radius:20px;
  color: slategrey;
  text-transform:uppercase;
  font-family: 'Ubuntu', sans-serif;
  cursor:pointer;
}

#log{
  height:30px;
  width:68px;
   font-size:xx-small;
  background:#fff;
  border:2px solid #f2f2f2;
  border-radius:1px;
  color: slategrey;
  cursor:pointer;
}

.no-access {
  color:black;
  text-decoration:underline;
  cursor:pointer;
}
  

/*Media Querie*/
@media only screen and (min-width : 100px) and (max-width : 530px){
  .login-form h3 {
    text-align:center;
    margin:0;
  }
  .sign-up, .no-access {
    margin:10px 0;
  }
  .login-button {
    margin-bottom:100px;
  }
}






  
  
  input[type=text], select {
    width: 50%;
    padding: 2px 2px;
    margin: 8px 0;
    display: inline-block;
    border: 1px solid #ccc;
    border-radius: 4px;
    box-sizing: border-box;
}

input[type=submit] {
    width: 50%;
    background-color: #cec35e;
    color: white;
	font-size: 18px;
	font-family:"Letter Gothic Std";
	font-weight:bold;
    padding: 12px 20px;
    margin: 8px 0;
    border: 2px solid white;
    border-radius: 4px;
    cursor: pointer;
}

input[type=submit]:hover {
color: white;
    background-color: white;
	color:#cec35e;
	border: 2px solid #cec35e;
}

.veer_css {
    border-radius: 0px;
    background-color:#b3e5a0;
    padding: 2px;
}

#vir{
    width: 50%;
    padding: 2px 2px;
    margin: 8px 0;
    display: inline-block;
    border: 1px solid #ccc;
    border-radius: 4px;
    box-sizing: border-box;
}
</style>

<meta name="description" content="toyam securities management pvt ltd Ranchi." />
<meta name="keywords" />
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="bootstrap.min.css">
  <script src="jquery.min.js"></script>
  <script src="bootstrap.min.js"></script>

  <link rel="stylesheet" href="style_index.css">
   

<link rel="shortcut icon" href="toyam.png" />
<link rel="apple-touch-icon" sizes="152x152" href="toyam.png"/>
<link rel="apple-touch-icon" sizes="120x120" href="toyam.png"/>
<link rel="apple-touch-icon" sizes="76x76" href="toyam.png"/>
<link rel="apple-touch-icon" sizes="60x60" href="toyam.png"/>
</head>
<body>






<nav class="navbar navbar-inverse">
  <div class="container-fluid">
    <div class="navbar-header">
      <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#myNavbar">
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>                        
      </button>
    </div>
    <div class="collapse navbar-collapse" id="myNavbar">
      <ul class="nav navbar-nav">
        <li class="active"><a href="index.php">Home</a></li>
        <li><a href="#"id="myBtn">BC Login</a></li>
		<!-- The Modal -->
		<div id="myModal" class="modal">
		<!-- Modal content -->
		<div class="modal-content">
		<span class="close">&times;</span>
		
		
		
		
		<div class="margin">


<div class="login">
  <div class="login-header">
  BUSSINESS CO-ORDINATOR LOGIN
  </div>
        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
            <div class="form-group <?php echo (!empty($username_err)) ? 'has-error' : ''; ?>">
                <label>Username:<sup>*</sup></label>
                <input type="text" name="username"class="form-control" value="<?php echo $username; ?>">
                <span class="help-block"><?php echo $username_err; ?></span>
            </div>    
            <div class="form-group <?php echo (!empty($password_err)) ? 'has-error' : ''; ?>">
                <label>Password:<sup>*</sup></label>
                <input type="password" name="password" class="form-control">
                <span class="help-block"><?php echo $password_err; ?></span>
            </div>
            <div class="form-group">
                <input type="submit" class="btn btn-primary" value="Submit">
            </div>
            <p>Don't have an account? <a href="register.php">Sign up now</a>.</p>
        </form>
 
 </div>


</div>
		
		
		

		</div>
		</div>

		
      </ul>
      <ul class="nav navbar-nav navbar-right">
        <li><a href="student_login.php"><span class="glyphicon glyphicon-log-in"></span> Student Login</a></li>
      </ul>
    </div>
  </div>
</nav>
	









<div class="jumbotron" style="padding:0;">
<!===============================================================!>
<div class="container-fluid bg-3 text-center" style="background-color:#dbd895;//#cec35e//DAA520">    
  <div class="row">

<br>
<div class="col-sm-2">
  <div class="container text-center">
    <img id="home" src="toyam.png">
  </div>
</div>
<div class="col-sm-8">
  <div class="container text-center">
	
    <p><font size="6" color="black" face="Orator Std"><strong>TOYAM SECURITY AND FACILITY MANAGEMENT PVT. LTD.</strong></font></p>
    
	
  </div>
</div>
<div class="col-sm-2">
  <div class="container text-center">
  
    <font size="2" color="white" face="Goudy Old Style">Toyam Securities and Facility Management Pvt. Ltd.</font>
                 <BR>
	<font size="2" color="white" face="Goudy Old Style">C/O- Executive Internet Cafe</font>
	<font size="2" color="white" face="Goudy Old Style">Ratu Chatti, P.O_+P.S- Ratu</font>
        <font size="2" color="white" face="Goudy Old Style">Pin-835222</font>
        <font size="2" color="white" face="Goudy Old Style">Dist.- Ranchi (JHARKHAND)</font>
  </div>
</div>

    </div>
  </div>

</div>









<div class="w3-row">
<div class="w3-quarter w3-container w3-white">
<br>
  <center>
        
	
	<a class="two" href="contact_us.php">CONTACT US</a>
	<br>
	<a class="two" href="our_branches.php">BRANCHES</a>
	<br>
	<a class="two" href="nearest_center.php">NEAREST CENTER</a>
	<br>
	<a class="two" href="about_us.php">ABOUT US</a>
	<br>
	<a class="two" href="http://www.blog.toyamservices.com">OUR BLOG</a>
	<br>
	
	
	</center>
</div>
<div class="w3-twothird w3-container">

<!---------------------------------------------------------------->  

  <div class="w3-container w3-half w3-red">
    <font size="5" color="" face="Tw Cen MT">Address</font> 
    <p>Toyam Securities and Facility Management Pvt. Ltd.
    <br>C/O- Executive Internet Cafe
	<br>Ratu Chatti, P.O_+P.S- Ratu
	<br>Pin- 835222
	<br>Dist.- Ranchi (JHARKHAND)</p>
	<p><font size="5" color="" face="Tw Cen MT">Phone no</font></p>
	<p>000-0000000
    <br>00000-0000
	</p>
	<p><font size="5" color="" face="Tw Cen MT">Mailing address</font></p>
	<p>info@toyamservices.com
    <br>support@toyamservices.com
	</p>
	<p><font size="5" color="" face="Tw Cen MT">Working hours</font></p>
	<p>9AM  TO   5PM
	<br>MONDAY TO FRIDAY
	</p>
	
  </div>
  <div class="w3-container w3-half">
  
  <center><font size="6" color="#f44336" face="Maiandra GD"><b>CONTACT US</b></font></center>
  <center>
    <!---form action="contact_us_sucess.php" class="w3-container w3-card-4 w3-light-pink w3-text-blue w3-margin" method="post"-->

 
<div class="w3-row w3-section">
  <div class="w3-col" style="width:50px"><i class="w3-xxlarge fa fa-user"></i></div>
    <div class="w3-rest">
      <input class="w3-input w3-border" name="fname" id="fname" type="text" placeholder="First Name">
    </div>
</div>

<div class="w3-row w3-section">
  <div class="w3-col" style="width:50px"><i class="w3-xxlarge fa fa-user"></i></div>
    <div class="w3-rest">
      <input class="w3-input w3-border" name="lname" id="lname" type="text" placeholder="Last Name">
    </div>
</div>

<div class="w3-row w3-section">
  <div class="w3-col" style="width:50px"><i class="w3-xxlarge fa fa-envelope-o"></i></div>
    <div class="w3-rest">
      <input class="w3-input w3-border" name="email" id="email" type="text" placeholder="Email">
    </div>
</div>

<div class="w3-row w3-section">
  <div class="w3-col" style="width:50px"><i class="w3-xxlarge fa fa-phone"></i></div>
    <div class="w3-rest">
      <input class="w3-input w3-border" name="phone" id="phone" type="text" placeholder="Phone">
    </div>
</div>

<div class="w3-row w3-section">
  <div class="w3-col" style="width:50px"><i class="w3-xxlarge fa fa-pencil"></i></div>
    <div class="w3-rest">
      <input class="w3-input w3-border" name="message" id="message" type="text" placeholder="Message">
    </div>
</div>

<button  id="veer_button" onclick="veer_alert()" class="w3-button w3-block w3-section w3-blue w3-ripple w3-padding" type="submit">Send</button>
<?php echo $msg_con; ?>
<!--------------------------------------------/form-----------> 

</center> 
  </div>


<!----------------------------------------------------------------->  
</div>


</div>




<footer class="container-fluid text-center">
<font color="white">
  <h5>
  Powered by&nbsp;
  <b></i><a href="http://www.vbpwebsoft.com"><font color="white">VBP Websoft</font></a></i></b>
  </h5>

<h6>Copyright &nbsp;&copy;TOYAM SECURITY & FACILITY MANAGEMENT PVT. LTD.&reg;
&nbsp; All Rights Reserved.
</h6></font></footer>






<script>
// Get the modal
var modal = document.getElementById('myModal');

// Get the button that opens the modal
var btn = document.getElementById("myBtn");

// Get the <span> element that closes the modal
var span = document.getElementsByClassName("close")[0];

// When the user clicks the button, open the modal 
btn.onclick = function() {
    modal.style.display = "block";
}

// When the user clicks on <span> (x), close the modal
span.onclick = function() {
    modal.style.display = "none";
}

// When the user clicks anywhere outside of the modal, close it
window.onclick = function(event) {
    if (event.target == modal) {
        modal.style.display = "none";
    }
}
</script>









	
</body>
</html>